VERSION 5.00
Begin VB.Form frmSystem 
   BorderStyle     =   1  'Fixed Single
   Caption         =   " System"
   ClientHeight    =   2835
   ClientLeft      =   150
   ClientTop       =   435
   ClientWidth     =   3420
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   189
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   228
   StartUpPosition =   1  'CenterOwner
   Begin VB.ComboBox cboVoltage 
      Height          =   315
      Left            =   3480
      TabIndex        =   2
      Text            =   "Combo1"
      Top             =   2040
      Visible         =   0   'False
      Width           =   3255
   End
   Begin VB.ComboBox cboSystem 
      Height          =   315
      Left            =   120
      Style           =   2  'Dropdown List
      TabIndex        =   1
      Top             =   1320
      Width           =   3255
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "OK"
      Height          =   375
      Left            =   120
      TabIndex        =   0
      Top             =   2400
      Width           =   3255
   End
   Begin VB.Label lblCurrent 
      BackColor       =   &H00FFFFFF&
      Height          =   255
      Left            =   840
      TabIndex        =   5
      Top             =   360
      Width           =   975
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Current :"
      Height          =   195
      Left            =   120
      TabIndex        =   4
      Top             =   360
      Width           =   600
   End
   Begin VB.Line Line1 
      X1              =   0
      X2              =   232
      Y1              =   0
      Y2              =   0
   End
   Begin VB.Label lblSystem 
      Caption         =   "Please Select Your System"
      Height          =   255
      Left            =   120
      TabIndex        =   3
      Top             =   1080
      Width           =   3135
   End
   Begin VB.Menu mnuCurrent 
      Caption         =   "Select &Current"
      Begin VB.Menu mnu79Amps 
         Caption         =   "&7.9 Amps"
      End
      Begin VB.Menu mnu80Amps 
         Caption         =   "&8.0 Amps"
      End
      Begin VB.Menu mnu82Amps 
         Caption         =   "8.&2 Amps"
      End
      Begin VB.Menu mnuOtherCurrent 
         Caption         =   "&Other"
      End
   End
   Begin VB.Menu mnuAddSystem 
      Caption         =   "Add a &System"
   End
End
Attribute VB_Name = "frmSystem"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim Current As Single

Private Sub cmdOK_Click()
    
    Open App.Path & "\LampCal.ini" For Input As #1
    Input #1, Temp, temp2
    Input #1, temp3, lVoltage
    Close #1
    
    lVoltage = CSng(cboVoltage.List(cboSystem.ListIndex)) * Current
    lVoltage = Format(lVoltage, "0.000000")
    Open App.Path & "\LampCal.ini" For Output As #1
    Write #1, Temp, temp2
    Write #1, temp3, lVoltage
    Close #1
      
    Open App.Path & "\Resistor.txt" For Input As #1
    Open App.Path & "\Resistor2.txt" For Output As #2
    Input #1, Temp, temp2
    Write #2, Temp, Current
    While Not EOF(1)
        Input #1, Temp, temp2
        Write #2, Temp, temp2
    Wend
    Close #1
    Close #2
    Kill App.Path & "\Resistor.txt"
    Name App.Path & "\Resistor2.txt" As App.Path & "\Resistor.txt"
    Unload Me
End Sub

Private Sub Form_Load()
    
    Open App.Path & "\Resistor.txt" For Input As #1
    Open App.Path & "\Lampcal.ini" For Input As #4
    Input #4, Temp, temp1
    Input #4, Temp, volt
    Close #4
    
    Input #1, Temp, temp2
    
    Current = CSng(temp2)
    i = 0
    indx = -1
    While Not EOF(1)
        Input #1, sSystem, VOltage
        cboSystem.AddItem sSystem
        cboVoltage.AddItem VOltage
        i = i + 1
        x = Format(volt / Current, "0.000000")
        If x = Format(VOltage, "0.000000") Then
            indx = i - 1
        End If
    Wend
    If indx = -1 Then indx = 0
    cboSystem.ListIndex = indx
    Close #1
    If Current = 7.9 Then
        Me.mnu79Amps.Checked = True
        lblCurrent.Caption = "7.9 Amps"
    ElseIf Current = 8 Then
        Me.mnu80Amps.Checked = True
        lblCurrent.Caption = "8.0 Amps"
    ElseIf Current = 8.2 Then
        Me.mnu82Amps.Checked = True
        lblCurrent.Caption = "8.2 Amps"
    Else
        Me.mnuOtherCurrent.Checked = True
        lblCurrent.Caption = Current & " Amps"
    End If
End Sub

Private Sub mnu79Amps_Click()
    mnu79Amps.Checked = True
    mnu80Amps.Checked = False
    mnu82Amps.Checked = False
    mnuOtherCurrent.Checked = False
    Current = 7.9
    lblCurrent.Caption = Current & " Amps"
End Sub

Private Sub mnu80Amps_Click()
    mnu79Amps.Checked = False
    mnu80Amps.Checked = True
    mnu82Amps.Checked = False
    mnuOtherCurrent.Checked = False
    Current = 8
    lblCurrent.Caption = Current & " Amps"
End Sub

Private Sub mnu82Amps_Click()
    mnu79Amps.Checked = False
    mnu80Amps.Checked = False
    mnu82Amps.Checked = True
    mnuOtherCurrent.Checked = False
    Current = 8.2
    lblCurrent.Caption = Current & " Amps"
End Sub

Private Sub mnuAddSystem_Click()
    Dim SystemName
    Dim Resp As VbMsgBoxResult
    SystemName = InputBox("Please Enter a Name For The New System ")
    While SystemName = ""
        SystemName = InputBox("Please Enter a Name For The New System ")
        If SystemName = "" Then
            Resp = MsgBox("Do you want to exit ?", vbYesNo)
            If Resp = vbYes Then
                Exit Sub
            End If
        End If
    Wend
    
    sResistance = InputBox("Please Enter the Calibrated Resistor Value", "Resistor")
    On Error Resume Next
    Resistance = CSng(sResistance)
    If Error <> "" Or Resistance <= 0 Then
        MsgBox sResistance & " is not a valid resistance value !"
        Exit Sub
    End If
    
    If Resistance > 2 Then
        warn = MsgBox(Resistance & " Ohms appears to be too large. May cause the system to over range." & vbCrLf & "Do you still want to continue ?", vbYesNo)
        If warn = vbNo Then
            Exit Sub
        End If
    End If
    
    Open App.Path & "\Resistor.txt" For Append As #5
    Write #5, SystemName, sResistance
    Close #5
    
    
    Open App.Path & "\LampCal.ini" For Input As #1
    Input #1, Temp, temp2
    Input #1, temp3, lVoltage
    Close #1
    
    lVoltage = CSng(sResistance) * Current
    lVoltage = Format(lVoltage, "0.000000")
    Open App.Path & "\LampCal.ini" For Output As #1
    Write #1, Temp, temp2
    Write #1, temp3, lVoltage
    Close #1
      
    Open App.Path & "\Resistor.txt" For Input As #1
    Open App.Path & "\Resistor2.txt" For Output As #2
    Input #1, Temp, temp2
    Write #2, Temp, Current
    While Not EOF(1)
        Input #1, Temp, temp2
        Write #2, Temp, temp2
    Wend
    Close #1
    Close #2
    Kill App.Path & "\Resistor.txt"
    Name App.Path & "\Resistor2.txt" As App.Path & "\Resistor.txt"
    
    cboSystem.Clear
    cboVoltage.Clear
    
    Call Form_Load
    
End Sub

Private Sub mnuOtherCurrent_Click()
    
    sCurrent = InputBox("Please Enter a Current Value", "Current")
    On Error Resume Next
    iCurrent = CSng(sCurrent)
    If Error <> "" Or iCurrent <= 0 Or iCurrent > 8.3 Then
        MsgBox sCurrent & " is not a valid current value ! Current must be between 0 and 8.3 Amps."
        Exit Sub
    End If
    Current = iCurrent
    lblCurrent.Caption = Current & " Amps"
    
    mnu79Amps.Checked = False
    mnu80Amps.Checked = False
    mnu82Amps.Checked = False
    mnuOtherCurrent.Checked = True
End Sub
